package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{
  TimeoutInSeconds,
  ConnectorParameters,
  Name
}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TaskScheduledEventDetails(
    resourceType: Name,
    resource: Name,
    region: Name,
    parameters: ConnectorParameters,
    timeoutInSeconds: Optional[TimeoutInSeconds] = Optional.Absent,
    heartbeatInSeconds: Optional[TimeoutInSeconds] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails = {
    import TaskScheduledEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails
      .builder()
      .resourceType(Name.unwrap(resourceType): java.lang.String)
      .resource(Name.unwrap(resource): java.lang.String)
      .region(Name.unwrap(region): java.lang.String)
      .parameters(ConnectorParameters.unwrap(parameters): java.lang.String)
      .optionallyWith(
        timeoutInSeconds.map(value =>
          TimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.timeoutInSeconds)
      .optionallyWith(
        heartbeatInSeconds.map(value =>
          TimeoutInSeconds.unwrap(value): java.lang.Long
        )
      )(_.heartbeatInSeconds)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly =
    zio.aws.sfn.model.TaskScheduledEventDetails.wrap(buildAwsValue())
}
object TaskScheduledEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TaskScheduledEventDetails =
      zio.aws.sfn.model.TaskScheduledEventDetails(
        resourceType,
        resource,
        region,
        parameters,
        timeoutInSeconds.map(value => value),
        heartbeatInSeconds.map(value => value)
      )
    def resourceType: Name
    def resource: Name
    def region: Name
    def parameters: ConnectorParameters
    def timeoutInSeconds: Optional[TimeoutInSeconds]
    def heartbeatInSeconds: Optional[TimeoutInSeconds]
    def getResourceType: ZIO[Any, Nothing, Name] = ZIO.succeed(resourceType)
    def getResource: ZIO[Any, Nothing, Name] = ZIO.succeed(resource)
    def getRegion: ZIO[Any, Nothing, Name] = ZIO.succeed(region)
    def getParameters: ZIO[Any, Nothing, ConnectorParameters] =
      ZIO.succeed(parameters)
    def getTimeoutInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("timeoutInSeconds", timeoutInSeconds)
    def getHeartbeatInSeconds: ZIO[Any, AwsError, TimeoutInSeconds] =
      AwsError.unwrapOptionField("heartbeatInSeconds", heartbeatInSeconds)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails
  ) extends zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly {
    override val resourceType: Name =
      zio.aws.sfn.model.primitives.Name(impl.resourceType())
    override val resource: Name =
      zio.aws.sfn.model.primitives.Name(impl.resource())
    override val region: Name = zio.aws.sfn.model.primitives.Name(impl.region())
    override val parameters: ConnectorParameters =
      zio.aws.sfn.model.primitives.ConnectorParameters(impl.parameters())
    override val timeoutInSeconds: Optional[TimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.timeoutInSeconds())
        .map(value => zio.aws.sfn.model.primitives.TimeoutInSeconds(value))
    override val heartbeatInSeconds: Optional[TimeoutInSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.heartbeatInSeconds())
        .map(value => zio.aws.sfn.model.primitives.TimeoutInSeconds(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TaskScheduledEventDetails
  ): zio.aws.sfn.model.TaskScheduledEventDetails.ReadOnly = new Wrapper(impl)
}
