package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Name
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TaskStartedEventDetails(resourceType: Name, resource: Name) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails = {
    import TaskStartedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails
      .builder()
      .resourceType(Name.unwrap(resourceType): java.lang.String)
      .resource(Name.unwrap(resource): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly =
    zio.aws.sfn.model.TaskStartedEventDetails.wrap(buildAwsValue())
}
object TaskStartedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TaskStartedEventDetails =
      zio.aws.sfn.model.TaskStartedEventDetails(resourceType, resource)
    def resourceType: Name
    def resource: Name
    def getResourceType: ZIO[Any, Nothing, Name] = ZIO.succeed(resourceType)
    def getResource: ZIO[Any, Nothing, Name] = ZIO.succeed(resource)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails
  ) extends zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly {
    override val resourceType: Name =
      zio.aws.sfn.model.primitives.Name(impl.resourceType())
    override val resource: Name =
      zio.aws.sfn.model.primitives.Name(impl.resource())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TaskStartedEventDetails
  ): zio.aws.sfn.model.TaskStartedEventDetails.ReadOnly = new Wrapper(impl)
}
