package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Definition, Arn}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateStateMachineRequest(
    stateMachineArn: Arn,
    definition: Optional[Definition] = Optional.Absent,
    roleArn: Optional[Arn] = Optional.Absent,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest = {
    import UpdateStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(
        definition.map(value => Definition.unwrap(value): java.lang.String)
      )(_.definition)
      .optionallyWith(
        roleArn.map(value => Arn.unwrap(value): java.lang.String)
      )(_.roleArn)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineRequest.wrap(buildAwsValue())
}
object UpdateStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineRequest =
      zio.aws.sfn.model.UpdateStateMachineRequest(
        stateMachineArn,
        definition.map(value => value),
        roleArn.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        tracingConfiguration.map(value => value.asEditable)
      )
    def stateMachineArn: Arn
    def definition: Optional[Definition]
    def roleArn: Optional[Arn]
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getDefinition: ZIO[Any, AwsError, Definition] =
      AwsError.unwrapOptionField("definition", definition)
    def getRoleArn: ZIO[Any, AwsError, Arn] =
      AwsError.unwrapOptionField("roleArn", roleArn)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ) extends zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val definition: Optional[Definition] = zio.aws.core.internal
      .optionalFromNullable(impl.definition())
      .map(value => zio.aws.sfn.model.primitives.Definition(value))
    override val roleArn: Optional[Arn] = zio.aws.core.internal
      .optionalFromNullable(impl.roleArn())
      .map(value => zio.aws.sfn.model.primitives.Arn(value))
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineRequest
  ): zio.aws.sfn.model.UpdateStateMachineRequest.ReadOnly = new Wrapper(impl)
}
