package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Timestamp
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class UpdateStateMachineResponse(updateDate: Timestamp) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse = {
    import UpdateStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
      .builder()
      .updateDate(Timestamp.unwrap(updateDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.UpdateStateMachineResponse.wrap(buildAwsValue())
}
object UpdateStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.UpdateStateMachineResponse =
      zio.aws.sfn.model.UpdateStateMachineResponse(updateDate)
    def updateDate: Timestamp
    def getUpdateDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(updateDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ) extends zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly {
    override val updateDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.updateDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.UpdateStateMachineResponse
  ): zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly = new Wrapper(impl)
}
