package zio.aws.sfn
import zio.aws.sfn.model.ListTagsForResourceResponse.ReadOnly
import zio.mock.{Proxy, Mock}
import software.amazon.awssdk.services.sfn.SfnAsyncClient
import zio.aws.core.AwsError
import zio.aws.core.aspects.AwsCallAspect
import zio.{IO, ZEnvironment, URLayer}
import zio.aws.sfn.model.{
  SendTaskFailureRequest,
  DescribeStateMachineForExecutionRequest,
  SendTaskHeartbeatRequest,
  UpdateStateMachineRequest,
  GetActivityTaskRequest,
  ListTagsForResourceRequest,
  StartSyncExecutionRequest,
  GetExecutionHistoryRequest,
  StartExecutionRequest,
  ListExecutionsRequest,
  CreateStateMachineRequest,
  CreateActivityRequest,
  DescribeActivityRequest,
  ListActivitiesRequest,
  StopExecutionRequest,
  DescribeStateMachineRequest,
  DeleteStateMachineRequest,
  UntagResourceRequest,
  ListStateMachinesRequest,
  DeleteActivityRequest,
  SendTaskSuccessRequest,
  DescribeExecutionRequest,
  TagResourceRequest
}
import zio.stream.ZStream
object SfnMock extends Mock[Sfn] {
  object StartExecution
      extends Effect[
        StartExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StartExecutionResponse.ReadOnly
      ]
  object GetExecutionHistory
      extends Stream[
        GetExecutionHistoryRequest,
        AwsError,
        zio.aws.sfn.model.HistoryEvent.ReadOnly
      ]
  object GetExecutionHistoryPaginated
      extends Effect[
        GetExecutionHistoryRequest,
        AwsError,
        zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly
      ]
  object DeleteStateMachine
      extends Effect[
        DeleteStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly
      ]
  object CreateStateMachine
      extends Effect[
        CreateStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly
      ]
  object DescribeStateMachineForExecution
      extends Effect[
        DescribeStateMachineForExecutionRequest,
        AwsError,
        zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
      ]
  object StopExecution
      extends Effect[
        StopExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StopExecutionResponse.ReadOnly
      ]
  object GetActivityTask
      extends Effect[
        GetActivityTaskRequest,
        AwsError,
        zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly
      ]
  object DescribeExecution
      extends Effect[
        DescribeExecutionRequest,
        AwsError,
        zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly
      ]
  object StartSyncExecution
      extends Effect[
        StartSyncExecutionRequest,
        AwsError,
        zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly
      ]
  object SendTaskSuccess
      extends Effect[
        SendTaskSuccessRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly
      ]
  object SendTaskHeartbeat
      extends Effect[
        SendTaskHeartbeatRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly
      ]
  object DescribeStateMachine
      extends Effect[
        DescribeStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly
      ]
  object DeleteActivity
      extends Effect[
        DeleteActivityRequest,
        AwsError,
        zio.aws.sfn.model.DeleteActivityResponse.ReadOnly
      ]
  object UpdateStateMachine
      extends Effect[
        UpdateStateMachineRequest,
        AwsError,
        zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly
      ]
  object UntagResource
      extends Effect[
        UntagResourceRequest,
        AwsError,
        zio.aws.sfn.model.UntagResourceResponse.ReadOnly
      ]
  object ListActivities
      extends Stream[
        ListActivitiesRequest,
        AwsError,
        zio.aws.sfn.model.ActivityListItem.ReadOnly
      ]
  object ListActivitiesPaginated
      extends Effect[
        ListActivitiesRequest,
        AwsError,
        zio.aws.sfn.model.ListActivitiesResponse.ReadOnly
      ]
  object ListStateMachines
      extends Stream[
        ListStateMachinesRequest,
        AwsError,
        zio.aws.sfn.model.StateMachineListItem.ReadOnly
      ]
  object ListStateMachinesPaginated
      extends Effect[
        ListStateMachinesRequest,
        AwsError,
        zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly
      ]
  object ListExecutions
      extends Stream[
        ListExecutionsRequest,
        AwsError,
        zio.aws.sfn.model.ExecutionListItem.ReadOnly
      ]
  object ListExecutionsPaginated
      extends Effect[
        ListExecutionsRequest,
        AwsError,
        zio.aws.sfn.model.ListExecutionsResponse.ReadOnly
      ]
  object CreateActivity
      extends Effect[
        CreateActivityRequest,
        AwsError,
        zio.aws.sfn.model.CreateActivityResponse.ReadOnly
      ]
  object ListTagsForResource
      extends Effect[ListTagsForResourceRequest, AwsError, ReadOnly]
  object SendTaskFailure
      extends Effect[
        SendTaskFailureRequest,
        AwsError,
        zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly
      ]
  object TagResource
      extends Effect[
        TagResourceRequest,
        AwsError,
        zio.aws.sfn.model.TagResourceResponse.ReadOnly
      ]
  object DescribeActivity
      extends Effect[
        DescribeActivityRequest,
        AwsError,
        zio.aws.sfn.model.DescribeActivityResponse.ReadOnly
      ]
  val compose: URLayer[Proxy, Sfn] = zio.ZLayer {
    zio.ZIO.service[Proxy].flatMap { proxy =>
      withRuntime[Proxy, Sfn] { rts =>
        zio.ZIO.succeed {
          new Sfn {
            val api: SfnAsyncClient = null
            def withAspect[R1](
                newAspect: AwsCallAspect[R1],
                r: ZEnvironment[R1]
            ): Sfn = this
            def startExecution(
                request: StartExecutionRequest
            ): IO[AwsError, zio.aws.sfn.model.StartExecutionResponse.ReadOnly] =
              proxy(StartExecution, request)
            def getExecutionHistory(
                request: GetExecutionHistoryRequest
            ): ZStream[Any, AwsError, zio.aws.sfn.model.HistoryEvent.ReadOnly] =
              zio.Unsafe.unsafe { implicit u =>
                rts.unsafe
                  .run {
                    proxy(GetExecutionHistory, request)
                  }
                  .getOrThrowFiberFailure()
              }
            def getExecutionHistoryPaginated(
                request: GetExecutionHistoryRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.GetExecutionHistoryResponse.ReadOnly
            ] = proxy(GetExecutionHistoryPaginated, request)
            def deleteStateMachine(request: DeleteStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.DeleteStateMachineResponse.ReadOnly
            ] = proxy(DeleteStateMachine, request)
            def createStateMachine(request: CreateStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly
            ] = proxy(CreateStateMachine, request)
            def describeStateMachineForExecution(
                request: DescribeStateMachineForExecutionRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.DescribeStateMachineForExecutionResponse.ReadOnly
            ] = proxy(DescribeStateMachineForExecution, request)
            def stopExecution(
                request: StopExecutionRequest
            ): IO[AwsError, zio.aws.sfn.model.StopExecutionResponse.ReadOnly] =
              proxy(StopExecution, request)
            def getActivityTask(request: GetActivityTaskRequest): IO[
              AwsError,
              zio.aws.sfn.model.GetActivityTaskResponse.ReadOnly
            ] = proxy(GetActivityTask, request)
            def describeExecution(request: DescribeExecutionRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly
            ] = proxy(DescribeExecution, request)
            def startSyncExecution(request: StartSyncExecutionRequest): IO[
              AwsError,
              zio.aws.sfn.model.StartSyncExecutionResponse.ReadOnly
            ] = proxy(StartSyncExecution, request)
            def sendTaskSuccess(request: SendTaskSuccessRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskSuccessResponse.ReadOnly
            ] = proxy(SendTaskSuccess, request)
            def sendTaskHeartbeat(request: SendTaskHeartbeatRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskHeartbeatResponse.ReadOnly
            ] = proxy(SendTaskHeartbeat, request)
            def describeStateMachine(request: DescribeStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly
            ] = proxy(DescribeStateMachine, request)
            def deleteActivity(
                request: DeleteActivityRequest
            ): IO[AwsError, zio.aws.sfn.model.DeleteActivityResponse.ReadOnly] =
              proxy(DeleteActivity, request)
            def updateStateMachine(request: UpdateStateMachineRequest): IO[
              AwsError,
              zio.aws.sfn.model.UpdateStateMachineResponse.ReadOnly
            ] = proxy(UpdateStateMachine, request)
            def untagResource(
                request: UntagResourceRequest
            ): IO[AwsError, zio.aws.sfn.model.UntagResourceResponse.ReadOnly] =
              proxy(UntagResource, request)
            def listActivities(request: ListActivitiesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.ActivityListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListActivities, request)
                }
                .getOrThrowFiberFailure()
            }
            def listActivitiesPaginated(
                request: ListActivitiesRequest
            ): IO[AwsError, zio.aws.sfn.model.ListActivitiesResponse.ReadOnly] =
              proxy(ListActivitiesPaginated, request)
            def listStateMachines(request: ListStateMachinesRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.StateMachineListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListStateMachines, request)
                }
                .getOrThrowFiberFailure()
            }
            def listStateMachinesPaginated(
                request: ListStateMachinesRequest
            ): IO[
              AwsError,
              zio.aws.sfn.model.ListStateMachinesResponse.ReadOnly
            ] = proxy(ListStateMachinesPaginated, request)
            def listExecutions(request: ListExecutionsRequest): ZStream[
              Any,
              AwsError,
              zio.aws.sfn.model.ExecutionListItem.ReadOnly
            ] = zio.Unsafe.unsafe { implicit u =>
              rts.unsafe
                .run {
                  proxy(ListExecutions, request)
                }
                .getOrThrowFiberFailure()
            }
            def listExecutionsPaginated(
                request: ListExecutionsRequest
            ): IO[AwsError, zio.aws.sfn.model.ListExecutionsResponse.ReadOnly] =
              proxy(ListExecutionsPaginated, request)
            def createActivity(
                request: CreateActivityRequest
            ): IO[AwsError, zio.aws.sfn.model.CreateActivityResponse.ReadOnly] =
              proxy(CreateActivity, request)
            def listTagsForResource(
                request: ListTagsForResourceRequest
            ): IO[AwsError, ReadOnly] = proxy(ListTagsForResource, request)
            def sendTaskFailure(request: SendTaskFailureRequest): IO[
              AwsError,
              zio.aws.sfn.model.SendTaskFailureResponse.ReadOnly
            ] = proxy(SendTaskFailure, request)
            def tagResource(
                request: TagResourceRequest
            ): IO[AwsError, zio.aws.sfn.model.TagResourceResponse.ReadOnly] =
              proxy(TagResource, request)
            def describeActivity(request: DescribeActivityRequest): IO[
              AwsError,
              zio.aws.sfn.model.DescribeActivityResponse.ReadOnly
            ] = proxy(DescribeActivity, request)
          }
        }
      }
    }
  }
}
