package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.SensitiveData
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ActivitySucceededEventDetails(
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails = {
    import ActivitySucceededEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails
      .builder()
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly =
    zio.aws.sfn.model.ActivitySucceededEventDetails.wrap(buildAwsValue())
}
object ActivitySucceededEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ActivitySucceededEventDetails =
      zio.aws.sfn.model.ActivitySucceededEventDetails(
        output.map(value => value),
        outputDetails.map(value => value.asEditable)
      )
    def output: Optional[SensitiveData]
    def outputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails
  ) extends zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly {
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ActivitySucceededEventDetails
  ): zio.aws.sfn.model.ActivitySucceededEventDetails.ReadOnly = new Wrapper(
    impl
  )
}
