package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{BilledDuration, BilledMemoryUsed}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class BillingDetails(
    billedMemoryUsedInMB: Optional[BilledMemoryUsed] = Optional.Absent,
    billedDurationInMilliseconds: Optional[BilledDuration] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.BillingDetails = {
    import BillingDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.BillingDetails
      .builder()
      .optionallyWith(
        billedMemoryUsedInMB.map(value =>
          BilledMemoryUsed.unwrap(value): java.lang.Long
        )
      )(_.billedMemoryUsedInMB)
      .optionallyWith(
        billedDurationInMilliseconds.map(value =>
          BilledDuration.unwrap(value): java.lang.Long
        )
      )(_.billedDurationInMilliseconds)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.BillingDetails.ReadOnly =
    zio.aws.sfn.model.BillingDetails.wrap(buildAwsValue())
}
object BillingDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.BillingDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.BillingDetails =
      zio.aws.sfn.model.BillingDetails(
        billedMemoryUsedInMB.map(value => value),
        billedDurationInMilliseconds.map(value => value)
      )
    def billedMemoryUsedInMB: Optional[BilledMemoryUsed]
    def billedDurationInMilliseconds: Optional[BilledDuration]
    def getBilledMemoryUsedInMB: ZIO[Any, AwsError, BilledMemoryUsed] =
      AwsError.unwrapOptionField("billedMemoryUsedInMB", billedMemoryUsedInMB)
    def getBilledDurationInMilliseconds: ZIO[Any, AwsError, BilledDuration] =
      AwsError.unwrapOptionField(
        "billedDurationInMilliseconds",
        billedDurationInMilliseconds
      )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.BillingDetails
  ) extends zio.aws.sfn.model.BillingDetails.ReadOnly {
    override val billedMemoryUsedInMB: Optional[BilledMemoryUsed] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billedMemoryUsedInMB())
        .map(value => zio.aws.sfn.model.primitives.BilledMemoryUsed(value))
    override val billedDurationInMilliseconds: Optional[BilledDuration] =
      zio.aws.core.internal
        .optionalFromNullable(impl.billedDurationInMilliseconds())
        .map(value => zio.aws.sfn.model.primitives.BilledDuration(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.BillingDetails
  ): zio.aws.sfn.model.BillingDetails.ReadOnly = new Wrapper(impl)
}
