package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Arn, Definition, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateStateMachineRequest(
    name: Name,
    definition: Definition,
    roleArn: Arn,
    `type`: Optional[zio.aws.sfn.model.StateMachineType] = Optional.Absent,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tags: Optional[Iterable[zio.aws.sfn.model.Tag]] = Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest = {
    import CreateStateMachineRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest
      .builder()
      .name(Name.unwrap(name): java.lang.String)
      .definition(Definition.unwrap(definition): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateStateMachineRequest.ReadOnly =
    zio.aws.sfn.model.CreateStateMachineRequest.wrap(buildAwsValue())
}
object CreateStateMachineRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateStateMachineRequest =
      zio.aws.sfn.model.CreateStateMachineRequest(
        name,
        definition,
        roleArn,
        `type`.map(value => value),
        loggingConfiguration.map(value => value.asEditable),
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        tracingConfiguration.map(value => value.asEditable)
      )
    def name: Name
    def definition: Definition
    def roleArn: Arn
    def `type`: Optional[zio.aws.sfn.model.StateMachineType]
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getType: ZIO[Any, AwsError, zio.aws.sfn.model.StateMachineType] =
      AwsError.unwrapOptionField("type", `type`)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTags: ZIO[Any, AwsError, List[zio.aws.sfn.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest
  ) extends zio.aws.sfn.model.CreateStateMachineRequest.ReadOnly {
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val roleArn: Arn = zio.aws.sfn.model.primitives.Arn(impl.roleArn())
    override val `type`: Optional[zio.aws.sfn.model.StateMachineType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sfn.model.StateMachineType.wrap(value))
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tags: Optional[List[zio.aws.sfn.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sfn.model.Tag.wrap(item)
          }.toList
        )
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineRequest
  ): zio.aws.sfn.model.CreateStateMachineRequest.ReadOnly = new Wrapper(impl)
}
