package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class CreateStateMachineResponse(
    stateMachineArn: Arn,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse = {
    import CreateStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.CreateStateMachineResponse.wrap(buildAwsValue())
}
object CreateStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.CreateStateMachineResponse =
      zio.aws.sfn.model
        .CreateStateMachineResponse(stateMachineArn, creationDate)
    def stateMachineArn: Arn
    def creationDate: Timestamp
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ) extends zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.CreateStateMachineResponse
  ): zio.aws.sfn.model.CreateStateMachineResponse.ReadOnly = new Wrapper(impl)
}
