package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{Timestamp, Name, Arn}
import zio.aws.core.BuilderHelper
import java.time.Instant
import scala.jdk.CollectionConverters.*
final case class DescribeActivityResponse(
    activityArn: Arn,
    name: Name,
    creationDate: Timestamp
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeActivityResponse = {
    import DescribeActivityResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
      .builder()
      .activityArn(Arn.unwrap(activityArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeActivityResponse.ReadOnly =
    zio.aws.sfn.model.DescribeActivityResponse.wrap(buildAwsValue())
}
object DescribeActivityResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeActivityResponse =
      zio.aws.sfn.model
        .DescribeActivityResponse(activityArn, name, creationDate)
    def activityArn: Arn
    def name: Name
    def creationDate: Timestamp
    def getActivityArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(activityArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ) extends zio.aws.sfn.model.DescribeActivityResponse.ReadOnly {
    override val activityArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.activityArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeActivityResponse
  ): zio.aws.sfn.model.DescribeActivityResponse.ReadOnly = new Wrapper(impl)
}
