package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  Timestamp,
  Arn,
  SensitiveData,
  TraceHeader,
  Name
}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeExecutionResponse(
    executionArn: Arn,
    stateMachineArn: Arn,
    name: Optional[Name] = Optional.Absent,
    status: zio.aws.sfn.model.ExecutionStatus,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent,
    input: Optional[SensitiveData] = Optional.Absent,
    inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails
    ] = Optional.Absent,
    traceHeader: Optional[TraceHeader] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse = {
    import DescribeExecutionResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .optionallyWith(name.map(value => Name.unwrap(value): java.lang.String))(
        _.name
      )
      .status(status.unwrap)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .optionallyWith(
        input.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.input)
      .optionallyWith(inputDetails.map(value => value.buildAwsValue()))(
        _.inputDetails
      )
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .optionallyWith(
        traceHeader.map(value => TraceHeader.unwrap(value): java.lang.String)
      )(_.traceHeader)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly =
    zio.aws.sfn.model.DescribeExecutionResponse.wrap(buildAwsValue())
}
object DescribeExecutionResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeExecutionResponse =
      zio.aws.sfn.model.DescribeExecutionResponse(
        executionArn,
        stateMachineArn,
        name.map(value => value),
        status,
        startDate,
        stopDate.map(value => value),
        input.map(value => value),
        inputDetails.map(value => value.asEditable),
        output.map(value => value),
        outputDetails.map(value => value.asEditable),
        traceHeader.map(value => value)
      )
    def executionArn: Arn
    def stateMachineArn: Arn
    def name: Optional[Name]
    def status: zio.aws.sfn.model.ExecutionStatus
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def input: Optional[SensitiveData]
    def inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def output: Optional[SensitiveData]
    def outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ]
    def traceHeader: Optional[TraceHeader]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, AwsError, Name] =
      AwsError.unwrapOptionField("name", name)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.ExecutionStatus] =
      ZIO.succeed(status)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
    def getInput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("input", input)
    def getInputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("inputDetails", inputDetails)
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
    def getTraceHeader: ZIO[Any, AwsError, TraceHeader] =
      AwsError.unwrapOptionField("traceHeader", traceHeader)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ) extends zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Optional[Name] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.sfn.model.primitives.Name(value))
    override val status: zio.aws.sfn.model.ExecutionStatus =
      zio.aws.sfn.model.ExecutionStatus.wrap(impl.status())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
    override val input: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.input())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val inputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.inputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.CloudWatchEventsExecutionDataDetails.wrap(value)
      )
    override val traceHeader: Optional[TraceHeader] = zio.aws.core.internal
      .optionalFromNullable(impl.traceHeader())
      .map(value => zio.aws.sfn.model.primitives.TraceHeader(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeExecutionResponse
  ): zio.aws.sfn.model.DescribeExecutionResponse.ReadOnly = new Wrapper(impl)
}
