package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, Definition, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class DescribeStateMachineResponse(
    stateMachineArn: Arn,
    name: Name,
    status: Optional[zio.aws.sfn.model.StateMachineStatus] = Optional.Absent,
    definition: Definition,
    roleArn: Arn,
    `type`: zio.aws.sfn.model.StateMachineType,
    creationDate: Timestamp,
    loggingConfiguration: Optional[zio.aws.sfn.model.LoggingConfiguration] =
      Optional.Absent,
    tracingConfiguration: Optional[zio.aws.sfn.model.TracingConfiguration] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse = {
    import DescribeStateMachineResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
      .builder()
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .definition(Definition.unwrap(definition): java.lang.String)
      .roleArn(Arn.unwrap(roleArn): java.lang.String)
      .`type`(`type`.unwrap)
      .creationDate(Timestamp.unwrap(creationDate): Instant)
      .optionallyWith(loggingConfiguration.map(value => value.buildAwsValue()))(
        _.loggingConfiguration
      )
      .optionallyWith(tracingConfiguration.map(value => value.buildAwsValue()))(
        _.tracingConfiguration
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly =
    zio.aws.sfn.model.DescribeStateMachineResponse.wrap(buildAwsValue())
}
object DescribeStateMachineResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.DescribeStateMachineResponse =
      zio.aws.sfn.model.DescribeStateMachineResponse(
        stateMachineArn,
        name,
        status.map(value => value),
        definition,
        roleArn,
        `type`,
        creationDate,
        loggingConfiguration.map(value => value.asEditable),
        tracingConfiguration.map(value => value.asEditable)
      )
    def stateMachineArn: Arn
    def name: Name
    def status: Optional[zio.aws.sfn.model.StateMachineStatus]
    def definition: Definition
    def roleArn: Arn
    def `type`: zio.aws.sfn.model.StateMachineType
    def creationDate: Timestamp
    def loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly]
    def tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly]
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStatus: ZIO[Any, AwsError, zio.aws.sfn.model.StateMachineStatus] =
      AwsError.unwrapOptionField("status", status)
    def getDefinition: ZIO[Any, Nothing, Definition] = ZIO.succeed(definition)
    def getRoleArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(roleArn)
    def getType: ZIO[Any, Nothing, zio.aws.sfn.model.StateMachineType] =
      ZIO.succeed(`type`)
    def getCreationDate: ZIO[Any, Nothing, Timestamp] =
      ZIO.succeed(creationDate)
    def getLoggingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("loggingConfiguration", loggingConfiguration)
    def getTracingConfiguration
        : ZIO[Any, AwsError, zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      AwsError.unwrapOptionField("tracingConfiguration", tracingConfiguration)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ) extends zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly {
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val status: Optional[zio.aws.sfn.model.StateMachineStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sfn.model.StateMachineStatus.wrap(value))
    override val definition: Definition =
      zio.aws.sfn.model.primitives.Definition(impl.definition())
    override val roleArn: Arn = zio.aws.sfn.model.primitives.Arn(impl.roleArn())
    override val `type`: zio.aws.sfn.model.StateMachineType =
      zio.aws.sfn.model.StateMachineType.wrap(impl.`type`())
    override val creationDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.creationDate())
    override val loggingConfiguration
        : Optional[zio.aws.sfn.model.LoggingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.loggingConfiguration())
        .map(value => zio.aws.sfn.model.LoggingConfiguration.wrap(value))
    override val tracingConfiguration
        : Optional[zio.aws.sfn.model.TracingConfiguration.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tracingConfiguration())
        .map(value => zio.aws.sfn.model.TracingConfiguration.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.DescribeStateMachineResponse
  ): zio.aws.sfn.model.DescribeStateMachineResponse.ReadOnly = new Wrapper(impl)
}
