package zio.aws.sfn.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{Timestamp, Name, Arn}
import zio.ZIO
import scala.jdk.CollectionConverters.*
final case class ExecutionListItem(
    executionArn: Arn,
    stateMachineArn: Arn,
    name: Name,
    status: zio.aws.sfn.model.ExecutionStatus,
    startDate: Timestamp,
    stopDate: Optional[Timestamp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ExecutionListItem = {
    import ExecutionListItem.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ExecutionListItem
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .stateMachineArn(Arn.unwrap(stateMachineArn): java.lang.String)
      .name(Name.unwrap(name): java.lang.String)
      .status(status.unwrap)
      .startDate(Timestamp.unwrap(startDate): Instant)
      .optionallyWith(stopDate.map(value => Timestamp.unwrap(value): Instant))(
        _.stopDate
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ExecutionListItem.ReadOnly =
    zio.aws.sfn.model.ExecutionListItem.wrap(buildAwsValue())
}
object ExecutionListItem {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ExecutionListItem =
      zio.aws.sfn.model.ExecutionListItem(
        executionArn,
        stateMachineArn,
        name,
        status,
        startDate,
        stopDate.map(value => value)
      )
    def executionArn: Arn
    def stateMachineArn: Arn
    def name: Name
    def status: zio.aws.sfn.model.ExecutionStatus
    def startDate: Timestamp
    def stopDate: Optional[Timestamp]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getStateMachineArn: ZIO[Any, Nothing, Arn] =
      ZIO.succeed(stateMachineArn)
    def getName: ZIO[Any, Nothing, Name] = ZIO.succeed(name)
    def getStatus: ZIO[Any, Nothing, zio.aws.sfn.model.ExecutionStatus] =
      ZIO.succeed(status)
    def getStartDate: ZIO[Any, Nothing, Timestamp] = ZIO.succeed(startDate)
    def getStopDate: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("stopDate", stopDate)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ) extends zio.aws.sfn.model.ExecutionListItem.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val stateMachineArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.stateMachineArn())
    override val name: Name = zio.aws.sfn.model.primitives.Name(impl.name())
    override val status: zio.aws.sfn.model.ExecutionStatus =
      zio.aws.sfn.model.ExecutionStatus.wrap(impl.status())
    override val startDate: Timestamp =
      zio.aws.sfn.model.primitives.Timestamp(impl.startDate())
    override val stopDate: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.stopDate())
      .map(value => zio.aws.sfn.model.primitives.Timestamp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ExecutionListItem
  ): zio.aws.sfn.model.ExecutionListItem.ReadOnly = new Wrapper(impl)
}
