package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{
  ReverseOrder,
  Arn,
  PageToken,
  PageSize,
  IncludeExecutionDataGetExecutionHistory
}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class GetExecutionHistoryRequest(
    executionArn: Arn,
    maxResults: Optional[PageSize] = Optional.Absent,
    reverseOrder: Optional[ReverseOrder] = Optional.Absent,
    nextToken: Optional[PageToken] = Optional.Absent,
    includeExecutionData: Optional[IncludeExecutionDataGetExecutionHistory] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest = {
    import GetExecutionHistoryRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest
      .builder()
      .executionArn(Arn.unwrap(executionArn): java.lang.String)
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        reverseOrder.map(value => ReverseOrder.unwrap(value): java.lang.Boolean)
      )(_.reverseOrder)
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        includeExecutionData.map(value =>
          IncludeExecutionDataGetExecutionHistory.unwrap(
            value
          ): java.lang.Boolean
        )
      )(_.includeExecutionData)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.GetExecutionHistoryRequest.ReadOnly =
    zio.aws.sfn.model.GetExecutionHistoryRequest.wrap(buildAwsValue())
}
object GetExecutionHistoryRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.GetExecutionHistoryRequest =
      zio.aws.sfn.model.GetExecutionHistoryRequest(
        executionArn,
        maxResults.map(value => value),
        reverseOrder.map(value => value),
        nextToken.map(value => value),
        includeExecutionData.map(value => value)
      )
    def executionArn: Arn
    def maxResults: Optional[PageSize]
    def reverseOrder: Optional[ReverseOrder]
    def nextToken: Optional[PageToken]
    def includeExecutionData: Optional[IncludeExecutionDataGetExecutionHistory]
    def getExecutionArn: ZIO[Any, Nothing, Arn] = ZIO.succeed(executionArn)
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getReverseOrder: ZIO[Any, AwsError, ReverseOrder] =
      AwsError.unwrapOptionField("reverseOrder", reverseOrder)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getIncludeExecutionData
        : ZIO[Any, AwsError, IncludeExecutionDataGetExecutionHistory] =
      AwsError.unwrapOptionField("includeExecutionData", includeExecutionData)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest
  ) extends zio.aws.sfn.model.GetExecutionHistoryRequest.ReadOnly {
    override val executionArn: Arn =
      zio.aws.sfn.model.primitives.Arn(impl.executionArn())
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
    override val reverseOrder: Optional[ReverseOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.reverseOrder())
      .map(value => zio.aws.sfn.model.primitives.ReverseOrder(value))
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
    override val includeExecutionData
        : Optional[IncludeExecutionDataGetExecutionHistory] =
      zio.aws.core.internal
        .optionalFromNullable(impl.includeExecutionData())
        .map(value =>
          zio.aws.sfn.model.primitives
            .IncludeExecutionDataGetExecutionHistory(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.GetExecutionHistoryRequest
  ): zio.aws.sfn.model.GetExecutionHistoryRequest.ReadOnly = new Wrapper(impl)
}
