package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.{PageToken, PageSize}
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class ListStateMachinesRequest(
    maxResults: Optional[PageSize] = Optional.Absent,
    nextToken: Optional[PageToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest = {
    import ListStateMachinesRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest
      .builder()
      .optionallyWith(maxResults.map(value => PageSize.unwrap(value): Integer))(
        _.maxResults
      )
      .optionallyWith(
        nextToken.map(value => PageToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.ListStateMachinesRequest.ReadOnly =
    zio.aws.sfn.model.ListStateMachinesRequest.wrap(buildAwsValue())
}
object ListStateMachinesRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.ListStateMachinesRequest =
      zio.aws.sfn.model.ListStateMachinesRequest(
        maxResults.map(value => value),
        nextToken.map(value => value)
      )
    def maxResults: Optional[PageSize]
    def nextToken: Optional[PageToken]
    def getMaxResults: ZIO[Any, AwsError, PageSize] =
      AwsError.unwrapOptionField("maxResults", maxResults)
    def getNextToken: ZIO[Any, AwsError, PageToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest
  ) extends zio.aws.sfn.model.ListStateMachinesRequest.ReadOnly {
    override val maxResults: Optional[PageSize] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sfn.model.primitives.PageSize(value))
    override val nextToken: Optional[PageToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sfn.model.primitives.PageToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.ListStateMachinesRequest
  ): zio.aws.sfn.model.ListStateMachinesRequest.ReadOnly = new Wrapper(impl)
}
