package zio.aws.sfn.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.sfn.model.primitives.UnsignedInteger
import zio.ZIO
import java.lang.Integer
import scala.jdk.CollectionConverters.*
final case class MapStateStartedEventDetails(
    length: Optional[UnsignedInteger] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.MapStateStartedEventDetails = {
    import MapStateStartedEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.MapStateStartedEventDetails
      .builder()
      .optionallyWith(
        length.map(value => UnsignedInteger.unwrap(value): Integer)
      )(_.length)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly =
    zio.aws.sfn.model.MapStateStartedEventDetails.wrap(buildAwsValue())
}
object MapStateStartedEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.MapStateStartedEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.MapStateStartedEventDetails =
      zio.aws.sfn.model.MapStateStartedEventDetails(length.map(value => value))
    def length: Optional[UnsignedInteger]
    def getLength: ZIO[Any, AwsError, UnsignedInteger] =
      AwsError.unwrapOptionField("length", length)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.MapStateStartedEventDetails
  ) extends zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly {
    override val length: Optional[UnsignedInteger] = zio.aws.core.internal
      .optionalFromNullable(impl.length())
      .map(value => zio.aws.sfn.model.primitives.UnsignedInteger(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.MapStateStartedEventDetails
  ): zio.aws.sfn.model.MapStateStartedEventDetails.ReadOnly = new Wrapper(impl)
}
