package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.{SensitiveData, Name}
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TaskSucceededEventDetails(
    resourceType: Name,
    resource: Name,
    output: Optional[SensitiveData] = Optional.Absent,
    outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails = {
    import TaskSucceededEventDetails.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails
      .builder()
      .resourceType(Name.unwrap(resourceType): java.lang.String)
      .resource(Name.unwrap(resource): java.lang.String)
      .optionallyWith(
        output.map(value => SensitiveData.unwrap(value): java.lang.String)
      )(_.output)
      .optionallyWith(outputDetails.map(value => value.buildAwsValue()))(
        _.outputDetails
      )
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly =
    zio.aws.sfn.model.TaskSucceededEventDetails.wrap(buildAwsValue())
}
object TaskSucceededEventDetails {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TaskSucceededEventDetails =
      zio.aws.sfn.model.TaskSucceededEventDetails(
        resourceType,
        resource,
        output.map(value => value),
        outputDetails.map(value => value.asEditable)
      )
    def resourceType: Name
    def resource: Name
    def output: Optional[SensitiveData]
    def outputDetails
        : Optional[zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly]
    def getResourceType: ZIO[Any, Nothing, Name] = ZIO.succeed(resourceType)
    def getResource: ZIO[Any, Nothing, Name] = ZIO.succeed(resource)
    def getOutput: ZIO[Any, AwsError, SensitiveData] =
      AwsError.unwrapOptionField("output", output)
    def getOutputDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = AwsError.unwrapOptionField("outputDetails", outputDetails)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails
  ) extends zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly {
    override val resourceType: Name =
      zio.aws.sfn.model.primitives.Name(impl.resourceType())
    override val resource: Name =
      zio.aws.sfn.model.primitives.Name(impl.resource())
    override val output: Optional[SensitiveData] = zio.aws.core.internal
      .optionalFromNullable(impl.output())
      .map(value => zio.aws.sfn.model.primitives.SensitiveData(value))
    override val outputDetails: Optional[
      zio.aws.sfn.model.HistoryEventExecutionDataDetails.ReadOnly
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.outputDetails())
      .map(value =>
        zio.aws.sfn.model.HistoryEventExecutionDataDetails.wrap(value)
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TaskSucceededEventDetails
  ): zio.aws.sfn.model.TaskSucceededEventDetails.ReadOnly = new Wrapper(impl)
}
