package zio.aws.sfn.model
import zio.ZIO
import zio.aws.sfn.model.primitives.Enabled
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class TracingConfiguration(
    enabled: Optional[Enabled] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sfn.model.TracingConfiguration = {
    import TracingConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sfn.model.TracingConfiguration
      .builder()
      .optionallyWith(
        enabled.map(value => Enabled.unwrap(value): java.lang.Boolean)
      )(_.enabled)
      .build()
  }
  def asReadOnly: zio.aws.sfn.model.TracingConfiguration.ReadOnly =
    zio.aws.sfn.model.TracingConfiguration.wrap(buildAwsValue())
}
object TracingConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sfn.model.TracingConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sfn.model.TracingConfiguration =
      zio.aws.sfn.model.TracingConfiguration(enabled.map(value => value))
    def enabled: Optional[Enabled]
    def getEnabled: ZIO[Any, AwsError, Enabled] =
      AwsError.unwrapOptionField("enabled", enabled)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sfn.model.TracingConfiguration
  ) extends zio.aws.sfn.model.TracingConfiguration.ReadOnly {
    override val enabled: Optional[Enabled] = zio.aws.core.internal
      .optionalFromNullable(impl.enabled())
      .map(value => zio.aws.sfn.model.primitives.Enabled(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sfn.model.TracingConfiguration
  ): zio.aws.sfn.model.TracingConfiguration.ReadOnly = new Wrapper(impl)
}
