package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppLaunchConfigurationStatus {
  def unwrap
      : software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus
}
object AppLaunchConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus
  ): zio.aws.sms.model.AppLaunchConfigurationStatus = value match {
    case software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.NOT_CONFIGURED =>
      val r = NOT_CONFIGURED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.CONFIGURED =>
      val r = CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.AppLaunchConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_CONFIGURED
      extends zio.aws.sms.model.AppLaunchConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.NOT_CONFIGURED
  }
  case object CONFIGURED
      extends zio.aws.sms.model.AppLaunchConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchConfigurationStatus.CONFIGURED
  }
}
