package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppLaunchStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.AppLaunchStatus
}
object AppLaunchStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppLaunchStatus
  ): zio.aws.sms.model.AppLaunchStatus = value match {
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.READY_FOR_CONFIGURATION =>
      val r = READY_FOR_CONFIGURATION
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.CONFIGURATION_IN_PROGRESS =>
      val r = CONFIGURATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.CONFIGURATION_INVALID =>
      val r = CONFIGURATION_INVALID
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.READY_FOR_LAUNCH =>
      val r = READY_FOR_LAUNCH
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.VALIDATION_IN_PROGRESS =>
      val r = VALIDATION_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_PENDING =>
      val r = LAUNCH_PENDING
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_IN_PROGRESS =>
      val r = LAUNCH_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCHED =>
      val r = LAUNCHED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.PARTIALLY_LAUNCHED =>
      val r = PARTIALLY_LAUNCHED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.DELTA_LAUNCH_IN_PROGRESS =>
      val r = DELTA_LAUNCH_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.DELTA_LAUNCH_FAILED =>
      val r = DELTA_LAUNCH_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_FAILED =>
      val r = LAUNCH_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATE_IN_PROGRESS =>
      val r = TERMINATE_IN_PROGRESS
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATE_FAILED =>
      val r = TERMINATE_FAILED
      r
    case software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATED =>
      val r = TERMINATED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object READY_FOR_CONFIGURATION
      extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.READY_FOR_CONFIGURATION
  }
  case object CONFIGURATION_IN_PROGRESS
      extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.CONFIGURATION_IN_PROGRESS
  }
  case object CONFIGURATION_INVALID extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.CONFIGURATION_INVALID
  }
  case object READY_FOR_LAUNCH extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.READY_FOR_LAUNCH
  }
  case object VALIDATION_IN_PROGRESS extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.VALIDATION_IN_PROGRESS
  }
  case object LAUNCH_PENDING extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_PENDING
  }
  case object LAUNCH_IN_PROGRESS extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_IN_PROGRESS
  }
  case object LAUNCHED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCHED
  }
  case object PARTIALLY_LAUNCHED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.PARTIALLY_LAUNCHED
  }
  case object DELTA_LAUNCH_IN_PROGRESS
      extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.DELTA_LAUNCH_IN_PROGRESS
  }
  case object DELTA_LAUNCH_FAILED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.DELTA_LAUNCH_FAILED
  }
  case object LAUNCH_FAILED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.LAUNCH_FAILED
  }
  case object TERMINATE_IN_PROGRESS extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATE_IN_PROGRESS
  }
  case object TERMINATE_FAILED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATE_FAILED
  }
  case object TERMINATED extends zio.aws.sms.model.AppLaunchStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppLaunchStatus =
      software.amazon.awssdk.services.sms.model.AppLaunchStatus.TERMINATED
  }
}
