package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppReplicationConfigurationStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus
}
object AppReplicationConfigurationStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus
  ): zio.aws.sms.model.AppReplicationConfigurationStatus = value match {
    case software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.NOT_CONFIGURED =>
      val r = NOT_CONFIGURED
      r
    case software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.CONFIGURED =>
      val r = CONFIGURED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.AppReplicationConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_CONFIGURED
      extends zio.aws.sms.model.AppReplicationConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.NOT_CONFIGURED
  }
  case object CONFIGURED
      extends zio.aws.sms.model.AppReplicationConfigurationStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus =
      software.amazon.awssdk.services.sms.model.AppReplicationConfigurationStatus.CONFIGURED
  }
}
