package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait AppStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.AppStatus
}
object AppStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.AppStatus
  ): zio.aws.sms.model.AppStatus = value match {
    case software.amazon.awssdk.services.sms.model.AppStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.CREATING =>
      val r = CREATING
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.ACTIVE =>
      val r = ACTIVE
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.UPDATING =>
      val r = UPDATING
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.DELETING =>
      val r = DELETING
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.sms.model.AppStatus.DELETE_FAILED =>
      val r = DELETE_FAILED
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object CREATING extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.CREATING
  }
  case object ACTIVE extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.ACTIVE
  }
  case object UPDATING extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.UPDATING
  }
  case object DELETING extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.DELETING
  }
  case object DELETED extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.DELETED
  }
  case object DELETE_FAILED extends zio.aws.sms.model.AppStatus {
    override def unwrap: software.amazon.awssdk.services.sms.model.AppStatus =
      software.amazon.awssdk.services.sms.model.AppStatus.DELETE_FAILED
  }
}
