package zio.aws.sms.model
import zio.aws.sms.model.primitives.{NonEmptyStringWithMaxLen255, ValidationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class AppValidationConfiguration(
    validationId: Optional[ValidationId] = Optional.Absent,
    name: Optional[NonEmptyStringWithMaxLen255] = Optional.Absent,
    appValidationStrategy: Optional[zio.aws.sms.model.AppValidationStrategy] =
      Optional.Absent,
    ssmValidationParameters: Optional[
      zio.aws.sms.model.SSMValidationParameters
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.AppValidationConfiguration = {
    import AppValidationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.AppValidationConfiguration
      .builder()
      .optionallyWith(
        validationId.map(value => ValidationId.unwrap(value): java.lang.String)
      )(_.validationId)
      .optionallyWith(
        name.map(value =>
          NonEmptyStringWithMaxLen255.unwrap(value): java.lang.String
        )
      )(_.name)
      .optionallyWith(appValidationStrategy.map(value => value.unwrap))(
        _.appValidationStrategy
      )
      .optionallyWith(
        ssmValidationParameters.map(value => value.buildAwsValue())
      )(_.ssmValidationParameters)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.AppValidationConfiguration.ReadOnly =
    zio.aws.sms.model.AppValidationConfiguration.wrap(buildAwsValue())
}
object AppValidationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.AppValidationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.AppValidationConfiguration =
      zio.aws.sms.model.AppValidationConfiguration(
        validationId.map(value => value),
        name.map(value => value),
        appValidationStrategy.map(value => value),
        ssmValidationParameters.map(value => value.asEditable)
      )
    def validationId: Optional[ValidationId]
    def name: Optional[NonEmptyStringWithMaxLen255]
    def appValidationStrategy: Optional[zio.aws.sms.model.AppValidationStrategy]
    def ssmValidationParameters
        : Optional[zio.aws.sms.model.SSMValidationParameters.ReadOnly]
    def getValidationId: ZIO[Any, AwsError, ValidationId] =
      AwsError.unwrapOptionField("validationId", validationId)
    def getName: ZIO[Any, AwsError, NonEmptyStringWithMaxLen255] =
      AwsError.unwrapOptionField("name", name)
    def getAppValidationStrategy
        : ZIO[Any, AwsError, zio.aws.sms.model.AppValidationStrategy] =
      AwsError.unwrapOptionField("appValidationStrategy", appValidationStrategy)
    def getSsmValidationParameters: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.SSMValidationParameters.ReadOnly
    ] = AwsError.unwrapOptionField(
      "ssmValidationParameters",
      ssmValidationParameters
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.AppValidationConfiguration
  ) extends zio.aws.sms.model.AppValidationConfiguration.ReadOnly {
    override val validationId: Optional[ValidationId] = zio.aws.core.internal
      .optionalFromNullable(impl.validationId())
      .map(value => zio.aws.sms.model.primitives.ValidationId(value))
    override val name: Optional[NonEmptyStringWithMaxLen255] =
      zio.aws.core.internal
        .optionalFromNullable(impl.name())
        .map(value =>
          zio.aws.sms.model.primitives.NonEmptyStringWithMaxLen255(value)
        )
    override val appValidationStrategy
        : Optional[zio.aws.sms.model.AppValidationStrategy] =
      zio.aws.core.internal
        .optionalFromNullable(impl.appValidationStrategy())
        .map(value => zio.aws.sms.model.AppValidationStrategy.wrap(value))
    override val ssmValidationParameters
        : Optional[zio.aws.sms.model.SSMValidationParameters.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ssmValidationParameters())
        .map(value => zio.aws.sms.model.SSMValidationParameters.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.AppValidationConfiguration
  ): zio.aws.sms.model.AppValidationConfiguration.ReadOnly = new Wrapper(impl)
}
