package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ConnectorStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.ConnectorStatus
}
object ConnectorStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ConnectorStatus
  ): zio.aws.sms.model.ConnectorStatus = value match {
    case software.amazon.awssdk.services.sms.model.ConnectorStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ConnectorStatus.HEALTHY =>
      val r = HEALTHY
      r
    case software.amazon.awssdk.services.sms.model.ConnectorStatus.UNHEALTHY =>
      val r = UNHEALTHY
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.ConnectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorStatus =
      software.amazon.awssdk.services.sms.model.ConnectorStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object HEALTHY extends zio.aws.sms.model.ConnectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorStatus =
      software.amazon.awssdk.services.sms.model.ConnectorStatus.HEALTHY
  }
  case object UNHEALTHY extends zio.aws.sms.model.ConnectorStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ConnectorStatus =
      software.amazon.awssdk.services.sms.model.ConnectorStatus.UNHEALTHY
  }
}
