package zio.aws.sms.model
import zio.aws.sms.model.primitives.ReplicationJobId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class CreateReplicationJobResponse(
    replicationJobId: Optional[ReplicationJobId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse = {
    import CreateReplicationJobResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse
      .builder()
      .optionallyWith(
        replicationJobId.map(value =>
          ReplicationJobId.unwrap(value): java.lang.String
        )
      )(_.replicationJobId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly =
    zio.aws.sms.model.CreateReplicationJobResponse.wrap(buildAwsValue())
}
object CreateReplicationJobResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.CreateReplicationJobResponse =
      zio.aws.sms.model
        .CreateReplicationJobResponse(replicationJobId.map(value => value))
    def replicationJobId: Optional[ReplicationJobId]
    def getReplicationJobId: ZIO[Any, AwsError, ReplicationJobId] =
      AwsError.unwrapOptionField("replicationJobId", replicationJobId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse
  ) extends zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly {
    override val replicationJobId: Optional[ReplicationJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobId())
        .map(value => zio.aws.sms.model.primitives.ReplicationJobId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.CreateReplicationJobResponse
  ): zio.aws.sms.model.CreateReplicationJobResponse.ReadOnly = new Wrapper(impl)
}
