package zio.aws.sms.model
import zio.aws.sms.model.primitives.{
  ForceTerminateApp,
  ForceStopAppReplication,
  AppId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class DeleteAppRequest(
    appId: Optional[AppId] = Optional.Absent,
    forceStopAppReplication: Optional[ForceStopAppReplication] =
      Optional.Absent,
    forceTerminateApp: Optional[ForceTerminateApp] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.DeleteAppRequest = {
    import DeleteAppRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.DeleteAppRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        forceStopAppReplication.map(value =>
          ForceStopAppReplication.unwrap(value): java.lang.Boolean
        )
      )(_.forceStopAppReplication)
      .optionallyWith(
        forceTerminateApp.map(value =>
          ForceTerminateApp.unwrap(value): java.lang.Boolean
        )
      )(_.forceTerminateApp)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.DeleteAppRequest.ReadOnly =
    zio.aws.sms.model.DeleteAppRequest.wrap(buildAwsValue())
}
object DeleteAppRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.DeleteAppRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.DeleteAppRequest =
      zio.aws.sms.model.DeleteAppRequest(
        appId.map(value => value),
        forceStopAppReplication.map(value => value),
        forceTerminateApp.map(value => value)
      )
    def appId: Optional[AppId]
    def forceStopAppReplication: Optional[ForceStopAppReplication]
    def forceTerminateApp: Optional[ForceTerminateApp]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getForceStopAppReplication
        : ZIO[Any, AwsError, ForceStopAppReplication] = AwsError
      .unwrapOptionField("forceStopAppReplication", forceStopAppReplication)
    def getForceTerminateApp: ZIO[Any, AwsError, ForceTerminateApp] =
      AwsError.unwrapOptionField("forceTerminateApp", forceTerminateApp)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.DeleteAppRequest
  ) extends zio.aws.sms.model.DeleteAppRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val forceStopAppReplication: Optional[ForceStopAppReplication] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceStopAppReplication())
        .map(value =>
          zio.aws.sms.model.primitives.ForceStopAppReplication(value)
        )
    override val forceTerminateApp: Optional[ForceTerminateApp] =
      zio.aws.core.internal
        .optionalFromNullable(impl.forceTerminateApp())
        .map(value => zio.aws.sms.model.primitives.ForceTerminateApp(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.DeleteAppRequest
  ): zio.aws.sms.model.DeleteAppRequest.ReadOnly = new Wrapper(impl)
}
