package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppIdWithValidation
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters._
final case class DeleteAppValidationConfigurationRequest(
    appId: AppIdWithValidation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest = {
    import DeleteAppValidationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest
      .builder()
      .appId(AppIdWithValidation.unwrap(appId): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.DeleteAppValidationConfigurationRequest.ReadOnly =
    zio.aws.sms.model.DeleteAppValidationConfigurationRequest
      .wrap(buildAwsValue())
}
object DeleteAppValidationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.DeleteAppValidationConfigurationRequest =
      zio.aws.sms.model.DeleteAppValidationConfigurationRequest(appId)
    def appId: AppIdWithValidation
    def getAppId: ZIO[Any, Nothing, AppIdWithValidation] = ZIO.succeed(appId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest
  ) extends zio.aws.sms.model.DeleteAppValidationConfigurationRequest.ReadOnly {
    override val appId: AppIdWithValidation =
      zio.aws.sms.model.primitives.AppIdWithValidation(impl.appId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.DeleteAppValidationConfigurationRequest
  ): zio.aws.sms.model.DeleteAppValidationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
