package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateChangeSetRequest(
    appId: Optional[AppId] = Optional.Absent,
    changesetFormat: Optional[zio.aws.sms.model.OutputFormat] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest = {
    import GenerateChangeSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(changesetFormat.map(value => value.unwrap))(
        _.changesetFormat
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GenerateChangeSetRequest.ReadOnly =
    zio.aws.sms.model.GenerateChangeSetRequest.wrap(buildAwsValue())
}
object GenerateChangeSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GenerateChangeSetRequest =
      zio.aws.sms.model.GenerateChangeSetRequest(
        appId.map(value => value),
        changesetFormat.map(value => value)
      )
    def appId: Optional[AppId]
    def changesetFormat: Optional[zio.aws.sms.model.OutputFormat]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getChangesetFormat: ZIO[Any, AwsError, zio.aws.sms.model.OutputFormat] =
      AwsError.unwrapOptionField("changesetFormat", changesetFormat)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest
  ) extends zio.aws.sms.model.GenerateChangeSetRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val changesetFormat: Optional[zio.aws.sms.model.OutputFormat] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changesetFormat())
        .map(value => zio.aws.sms.model.OutputFormat.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GenerateChangeSetRequest
  ): zio.aws.sms.model.GenerateChangeSetRequest.ReadOnly = new Wrapper(impl)
}
