package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GenerateTemplateResponse(
    s3Location: Optional[zio.aws.sms.model.S3Location] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GenerateTemplateResponse = {
    import GenerateTemplateResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GenerateTemplateResponse
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GenerateTemplateResponse.ReadOnly =
    zio.aws.sms.model.GenerateTemplateResponse.wrap(buildAwsValue())
}
object GenerateTemplateResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GenerateTemplateResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GenerateTemplateResponse =
      zio.aws.sms.model
        .GenerateTemplateResponse(s3Location.map(value => value.asEditable))
    def s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GenerateTemplateResponse
  ) extends zio.aws.sms.model.GenerateTemplateResponse.ReadOnly {
    override val s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GenerateTemplateResponse
  ): zio.aws.sms.model.GenerateTemplateResponse.ReadOnly = new Wrapper(impl)
}
