package zio.aws.sms.model
import zio.aws.sms.model.primitives.{AutoLaunch, RoleName, AppId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppLaunchConfigurationResponse(
    appId: Optional[AppId] = Optional.Absent,
    roleName: Optional[RoleName] = Optional.Absent,
    autoLaunch: Optional[AutoLaunch] = Optional.Absent,
    serverGroupLaunchConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerGroupLaunchConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse = {
    import GetAppLaunchConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .optionallyWith(
        autoLaunch.map(value => AutoLaunch.unwrap(value): java.lang.Boolean)
      )(_.autoLaunch)
      .optionallyWith(
        serverGroupLaunchConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroupLaunchConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly =
    zio.aws.sms.model.GetAppLaunchConfigurationResponse.wrap(buildAwsValue())
}
object GetAppLaunchConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppLaunchConfigurationResponse =
      zio.aws.sms.model.GetAppLaunchConfigurationResponse(
        appId.map(value => value),
        roleName.map(value => value),
        autoLaunch.map(value => value),
        serverGroupLaunchConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appId: Optional[AppId]
    def roleName: Optional[RoleName]
    def autoLaunch: Optional[AutoLaunch]
    def serverGroupLaunchConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly]
    ]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
    def getAutoLaunch: ZIO[Any, AwsError, AutoLaunch] =
      AwsError.unwrapOptionField("autoLaunch", autoLaunch)
    def getServerGroupLaunchConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverGroupLaunchConfigurations",
      serverGroupLaunchConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse
  ) extends zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
    override val autoLaunch: Optional[AutoLaunch] = zio.aws.core.internal
      .optionalFromNullable(impl.autoLaunch())
      .map(value => zio.aws.sms.model.primitives.AutoLaunch(value))
    override val serverGroupLaunchConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupLaunchConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerGroupLaunchConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppLaunchConfigurationResponse
  ): zio.aws.sms.model.GetAppLaunchConfigurationResponse.ReadOnly = new Wrapper(
    impl
  )
}
