package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppReplicationConfigurationResponse(
    serverGroupReplicationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerGroupReplicationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse = {
    import GetAppReplicationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse
      .builder()
      .optionallyWith(
        serverGroupReplicationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroupReplicationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly =
    zio.aws.sms.model.GetAppReplicationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetAppReplicationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppReplicationConfigurationResponse =
      zio.aws.sms.model.GetAppReplicationConfigurationResponse(
        serverGroupReplicationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverGroupReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly]
    ]
    def getServerGroupReplicationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverGroupReplicationConfigurations",
      serverGroupReplicationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse
  ) extends zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly {
    override val serverGroupReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupReplicationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerGroupReplicationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppReplicationConfigurationResponse
  ): zio.aws.sms.model.GetAppReplicationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
