package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppValidationConfigurationResponse(
    appValidationConfigurations: Optional[
      Iterable[zio.aws.sms.model.AppValidationConfiguration]
    ] = Optional.Absent,
    serverGroupValidationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerGroupValidationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse = {
    import GetAppValidationConfigurationResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse
      .builder()
      .optionallyWith(
        appValidationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appValidationConfigurations)
      .optionallyWith(
        serverGroupValidationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroupValidationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly =
    zio.aws.sms.model.GetAppValidationConfigurationResponse
      .wrap(buildAwsValue())
}
object GetAppValidationConfigurationResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppValidationConfigurationResponse =
      zio.aws.sms.model.GetAppValidationConfigurationResponse(
        appValidationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serverGroupValidationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appValidationConfigurations
        : Optional[List[zio.aws.sms.model.AppValidationConfiguration.ReadOnly]]
    def serverGroupValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly]
    ]
    def getAppValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.AppValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appValidationConfigurations",
      appValidationConfigurations
    )
    def getServerGroupValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverGroupValidationConfigurations",
      serverGroupValidationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse
  ) extends zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly {
    override val appValidationConfigurations: Optional[
      List[zio.aws.sms.model.AppValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appValidationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.AppValidationConfiguration.wrap(item)
        }.toList
      )
    override val serverGroupValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupValidationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerGroupValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationConfigurationResponse
  ): zio.aws.sms.model.GetAppValidationConfigurationResponse.ReadOnly =
    new Wrapper(impl)
}
