package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class GetAppValidationOutputResponse(
    validationOutputList: Optional[
      Iterable[zio.aws.sms.model.ValidationOutput]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse = {
    import GetAppValidationOutputResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse
      .builder()
      .optionallyWith(
        validationOutputList.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.validationOutputList)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly =
    zio.aws.sms.model.GetAppValidationOutputResponse.wrap(buildAwsValue())
}
object GetAppValidationOutputResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetAppValidationOutputResponse =
      zio.aws.sms.model.GetAppValidationOutputResponse(
        validationOutputList.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def validationOutputList
        : Optional[List[zio.aws.sms.model.ValidationOutput.ReadOnly]]
    def getValidationOutputList: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ValidationOutput.ReadOnly
    ]] =
      AwsError.unwrapOptionField("validationOutputList", validationOutputList)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse
  ) extends zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly {
    override val validationOutputList
        : Optional[List[zio.aws.sms.model.ValidationOutput.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.validationOutputList())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ValidationOutput.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetAppValidationOutputResponse
  ): zio.aws.sms.model.GetAppValidationOutputResponse.ReadOnly = new Wrapper(
    impl
  )
}
