package zio.aws.sms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{MaxResults, NextToken, ReplicationJobId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class GetReplicationJobsRequest(
    replicationJobId: Optional[ReplicationJobId] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest = {
    import GetReplicationJobsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest
      .builder()
      .optionallyWith(
        replicationJobId.map(value =>
          ReplicationJobId.unwrap(value): java.lang.String
        )
      )(_.replicationJobId)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.GetReplicationJobsRequest.ReadOnly =
    zio.aws.sms.model.GetReplicationJobsRequest.wrap(buildAwsValue())
}
object GetReplicationJobsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.GetReplicationJobsRequest =
      zio.aws.sms.model.GetReplicationJobsRequest(
        replicationJobId.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def replicationJobId: Optional[ReplicationJobId]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getReplicationJobId: ZIO[Any, AwsError, ReplicationJobId] =
      AwsError.unwrapOptionField("replicationJobId", replicationJobId)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest
  ) extends zio.aws.sms.model.GetReplicationJobsRequest.ReadOnly {
    override val replicationJobId: Optional[ReplicationJobId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationJobId())
        .map(value => zio.aws.sms.model.primitives.ReplicationJobId(value))
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sms.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.GetReplicationJobsRequest
  ): zio.aws.sms.model.GetReplicationJobsRequest.ReadOnly = new Wrapper(impl)
}
