package zio.aws.sms.model
import zio.aws.sms.model.primitives.RoleName
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ImportAppCatalogRequest(
    roleName: Optional[RoleName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest = {
    import ImportAppCatalogRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest
      .builder()
      .optionallyWith(
        roleName.map(value => RoleName.unwrap(value): java.lang.String)
      )(_.roleName)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ImportAppCatalogRequest.ReadOnly =
    zio.aws.sms.model.ImportAppCatalogRequest.wrap(buildAwsValue())
}
object ImportAppCatalogRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ImportAppCatalogRequest =
      zio.aws.sms.model.ImportAppCatalogRequest(roleName.map(value => value))
    def roleName: Optional[RoleName]
    def getRoleName: ZIO[Any, AwsError, RoleName] =
      AwsError.unwrapOptionField("roleName", roleName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest
  ) extends zio.aws.sms.model.ImportAppCatalogRequest.ReadOnly {
    override val roleName: Optional[RoleName] = zio.aws.core.internal
      .optionalFromNullable(impl.roleName())
      .map(value => zio.aws.sms.model.primitives.RoleName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ImportAppCatalogRequest
  ): zio.aws.sms.model.ImportAppCatalogRequest.ReadOnly = new Wrapper(impl)
}
