package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait LicenseType {
  def unwrap: software.amazon.awssdk.services.sms.model.LicenseType
}
object LicenseType {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.LicenseType
  ): zio.aws.sms.model.LicenseType = value match {
    case software.amazon.awssdk.services.sms.model.LicenseType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.LicenseType.AWS =>
      val r = AWS
      r
    case software.amazon.awssdk.services.sms.model.LicenseType.BYOL =>
      val r = BYOL
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.LicenseType {
    override def unwrap: software.amazon.awssdk.services.sms.model.LicenseType =
      software.amazon.awssdk.services.sms.model.LicenseType.UNKNOWN_TO_SDK_VERSION
  }
  case object AWS extends zio.aws.sms.model.LicenseType {
    override def unwrap: software.amazon.awssdk.services.sms.model.LicenseType =
      software.amazon.awssdk.services.sms.model.LicenseType.AWS
  }
  case object BYOL extends zio.aws.sms.model.LicenseType {
    override def unwrap: software.amazon.awssdk.services.sms.model.LicenseType =
      software.amazon.awssdk.services.sms.model.LicenseType.BYOL
  }
}
