package zio.aws.sms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{MaxResults, NextToken, AppId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ListAppsRequest(
    appIds: Optional[Iterable[AppId]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent,
    maxResults: Optional[MaxResults] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ListAppsRequest = {
    import ListAppsRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ListAppsRequest
      .builder()
      .optionallyWith(
        appIds.map(value =>
          value.map { item =>
            AppId.unwrap(item): java.lang.String
          }.asJavaCollection
        )
      )(_.appIds)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .optionallyWith(
        maxResults.map(value => MaxResults.unwrap(value): Integer)
      )(_.maxResults)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ListAppsRequest.ReadOnly =
    zio.aws.sms.model.ListAppsRequest.wrap(buildAwsValue())
}
object ListAppsRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ListAppsRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ListAppsRequest =
      zio.aws.sms.model.ListAppsRequest(
        appIds.map(value => value),
        nextToken.map(value => value),
        maxResults.map(value => value)
      )
    def appIds: Optional[List[AppId]]
    def nextToken: Optional[NextToken]
    def maxResults: Optional[MaxResults]
    def getAppIds: ZIO[Any, AwsError, List[AppId]] =
      AwsError.unwrapOptionField("appIds", appIds)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
    def getMaxResults: ZIO[Any, AwsError, MaxResults] =
      AwsError.unwrapOptionField("maxResults", maxResults)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ListAppsRequest
  ) extends zio.aws.sms.model.ListAppsRequest.ReadOnly {
    override val appIds: Optional[List[AppId]] = zio.aws.core.internal
      .optionalFromNullable(impl.appIds())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.primitives.AppId(item)
        }.toList
      )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
    override val maxResults: Optional[MaxResults] = zio.aws.core.internal
      .optionalFromNullable(impl.maxResults())
      .map(value => zio.aws.sms.model.primitives.MaxResults(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ListAppsRequest
  ): zio.aws.sms.model.ListAppsRequest.ReadOnly = new Wrapper(impl)
}
