package zio.aws.sms.model
import zio.aws.sms.model.primitives.NextToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ListAppsResponse(
    apps: Optional[Iterable[zio.aws.sms.model.AppSummary]] = Optional.Absent,
    nextToken: Optional[NextToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ListAppsResponse = {
    import ListAppsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ListAppsResponse
      .builder()
      .optionallyWith(
        apps.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.apps)
      .optionallyWith(
        nextToken.map(value => NextToken.unwrap(value): java.lang.String)
      )(_.nextToken)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ListAppsResponse.ReadOnly =
    zio.aws.sms.model.ListAppsResponse.wrap(buildAwsValue())
}
object ListAppsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ListAppsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ListAppsResponse =
      zio.aws.sms.model.ListAppsResponse(
        apps.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        nextToken.map(value => value)
      )
    def apps: Optional[List[zio.aws.sms.model.AppSummary.ReadOnly]]
    def nextToken: Optional[NextToken]
    def getApps
        : ZIO[Any, AwsError, List[zio.aws.sms.model.AppSummary.ReadOnly]] =
      AwsError.unwrapOptionField("apps", apps)
    def getNextToken: ZIO[Any, AwsError, NextToken] =
      AwsError.unwrapOptionField("nextToken", nextToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ListAppsResponse
  ) extends zio.aws.sms.model.ListAppsResponse.ReadOnly {
    override val apps: Optional[List[zio.aws.sms.model.AppSummary.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.apps())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.AppSummary.wrap(item)
          }.toList
        )
    override val nextToken: Optional[NextToken] = zio.aws.core.internal
      .optionalFromNullable(impl.nextToken())
      .map(value => zio.aws.sms.model.primitives.NextToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ListAppsResponse
  ): zio.aws.sms.model.ListAppsResponse.ReadOnly = new Wrapper(impl)
}
