package zio.aws.sms.model
import zio.aws.sms.model.primitives.{ValidationStatusMessage, ValidationId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotificationContext(
    validationId: Optional[ValidationId] = Optional.Absent,
    status: Optional[zio.aws.sms.model.ValidationStatus] = Optional.Absent,
    statusMessage: Optional[ValidationStatusMessage] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.NotificationContext = {
    import NotificationContext.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.NotificationContext
      .builder()
      .optionallyWith(
        validationId.map(value => ValidationId.unwrap(value): java.lang.String)
      )(_.validationId)
      .optionallyWith(status.map(value => value.unwrap))(_.status)
      .optionallyWith(
        statusMessage.map(value =>
          ValidationStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.NotificationContext.ReadOnly =
    zio.aws.sms.model.NotificationContext.wrap(buildAwsValue())
}
object NotificationContext {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.NotificationContext
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.NotificationContext =
      zio.aws.sms.model.NotificationContext(
        validationId.map(value => value),
        status.map(value => value),
        statusMessage.map(value => value)
      )
    def validationId: Optional[ValidationId]
    def status: Optional[zio.aws.sms.model.ValidationStatus]
    def statusMessage: Optional[ValidationStatusMessage]
    def getValidationId: ZIO[Any, AwsError, ValidationId] =
      AwsError.unwrapOptionField("validationId", validationId)
    def getStatus: ZIO[Any, AwsError, zio.aws.sms.model.ValidationStatus] =
      AwsError.unwrapOptionField("status", status)
    def getStatusMessage: ZIO[Any, AwsError, ValidationStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.NotificationContext
  ) extends zio.aws.sms.model.NotificationContext.ReadOnly {
    override val validationId: Optional[ValidationId] = zio.aws.core.internal
      .optionalFromNullable(impl.validationId())
      .map(value => zio.aws.sms.model.primitives.ValidationId(value))
    override val status: Optional[zio.aws.sms.model.ValidationStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.status())
        .map(value => zio.aws.sms.model.ValidationStatus.wrap(value))
    override val statusMessage: Optional[ValidationStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.sms.model.primitives.ValidationStatusMessage(value)
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.NotificationContext
  ): zio.aws.sms.model.NotificationContext.ReadOnly = new Wrapper(impl)
}
