package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppIdWithValidation
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class NotifyAppValidationOutputRequest(
    appId: AppIdWithValidation,
    notificationContext: Optional[zio.aws.sms.model.NotificationContext] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest = {
    import NotifyAppValidationOutputRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest
      .builder()
      .appId(AppIdWithValidation.unwrap(appId): java.lang.String)
      .optionallyWith(notificationContext.map(value => value.buildAwsValue()))(
        _.notificationContext
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.NotifyAppValidationOutputRequest.ReadOnly =
    zio.aws.sms.model.NotifyAppValidationOutputRequest.wrap(buildAwsValue())
}
object NotifyAppValidationOutputRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.NotifyAppValidationOutputRequest =
      zio.aws.sms.model.NotifyAppValidationOutputRequest(
        appId,
        notificationContext.map(value => value.asEditable)
      )
    def appId: AppIdWithValidation
    def notificationContext
        : Optional[zio.aws.sms.model.NotificationContext.ReadOnly]
    def getAppId: ZIO[Any, Nothing, AppIdWithValidation] = ZIO.succeed(appId)
    def getNotificationContext
        : ZIO[Any, AwsError, zio.aws.sms.model.NotificationContext.ReadOnly] =
      AwsError.unwrapOptionField("notificationContext", notificationContext)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest
  ) extends zio.aws.sms.model.NotifyAppValidationOutputRequest.ReadOnly {
    override val appId: AppIdWithValidation =
      zio.aws.sms.model.primitives.AppIdWithValidation(impl.appId())
    override val notificationContext
        : Optional[zio.aws.sms.model.NotificationContext.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.notificationContext())
        .map(value => zio.aws.sms.model.NotificationContext.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.NotifyAppValidationOutputRequest
  ): zio.aws.sms.model.NotifyAppValidationOutputRequest.ReadOnly = new Wrapper(
    impl
  )
}
