package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAppReplicationConfigurationRequest(
    appId: Optional[AppId] = Optional.Absent,
    serverGroupReplicationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerGroupReplicationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest = {
    import PutAppReplicationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest
      .builder()
      .optionallyWith(
        appId.map(value => AppId.unwrap(value): java.lang.String)
      )(_.appId)
      .optionallyWith(
        serverGroupReplicationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroupReplicationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.PutAppReplicationConfigurationRequest.ReadOnly =
    zio.aws.sms.model.PutAppReplicationConfigurationRequest
      .wrap(buildAwsValue())
}
object PutAppReplicationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.PutAppReplicationConfigurationRequest =
      zio.aws.sms.model.PutAppReplicationConfigurationRequest(
        appId.map(value => value),
        serverGroupReplicationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appId: Optional[AppId]
    def serverGroupReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly]
    ]
    def getAppId: ZIO[Any, AwsError, AppId] =
      AwsError.unwrapOptionField("appId", appId)
    def getServerGroupReplicationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverGroupReplicationConfigurations",
      serverGroupReplicationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest
  ) extends zio.aws.sms.model.PutAppReplicationConfigurationRequest.ReadOnly {
    override val appId: Optional[AppId] = zio.aws.core.internal
      .optionalFromNullable(impl.appId())
      .map(value => zio.aws.sms.model.primitives.AppId(value))
    override val serverGroupReplicationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupReplicationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupReplicationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerGroupReplicationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.PutAppReplicationConfigurationRequest
  ): zio.aws.sms.model.PutAppReplicationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
