package zio.aws.sms.model
import zio.aws.sms.model.primitives.AppIdWithValidation
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class PutAppValidationConfigurationRequest(
    appId: AppIdWithValidation,
    appValidationConfigurations: Optional[
      Iterable[zio.aws.sms.model.AppValidationConfiguration]
    ] = Optional.Absent,
    serverGroupValidationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerGroupValidationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest = {
    import PutAppValidationConfigurationRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest
      .builder()
      .appId(AppIdWithValidation.unwrap(appId): java.lang.String)
      .optionallyWith(
        appValidationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.appValidationConfigurations)
      .optionallyWith(
        serverGroupValidationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverGroupValidationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.PutAppValidationConfigurationRequest.ReadOnly =
    zio.aws.sms.model.PutAppValidationConfigurationRequest.wrap(buildAwsValue())
}
object PutAppValidationConfigurationRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.PutAppValidationConfigurationRequest =
      zio.aws.sms.model.PutAppValidationConfigurationRequest(
        appId,
        appValidationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        ),
        serverGroupValidationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def appId: AppIdWithValidation
    def appValidationConfigurations
        : Optional[List[zio.aws.sms.model.AppValidationConfiguration.ReadOnly]]
    def serverGroupValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly]
    ]
    def getAppId: ZIO[Any, Nothing, AppIdWithValidation] = ZIO.succeed(appId)
    def getAppValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.AppValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "appValidationConfigurations",
      appValidationConfigurations
    )
    def getServerGroupValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverGroupValidationConfigurations",
      serverGroupValidationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest
  ) extends zio.aws.sms.model.PutAppValidationConfigurationRequest.ReadOnly {
    override val appId: AppIdWithValidation =
      zio.aws.sms.model.primitives.AppIdWithValidation(impl.appId())
    override val appValidationConfigurations: Optional[
      List[zio.aws.sms.model.AppValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.appValidationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.AppValidationConfiguration.wrap(item)
        }.toList
      )
    override val serverGroupValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupValidationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerGroupValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.PutAppValidationConfigurationRequest
  ): zio.aws.sms.model.PutAppValidationConfigurationRequest.ReadOnly =
    new Wrapper(impl)
}
