package zio.aws.sms.model
import java.time.Instant
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  AmiId,
  Timestamp,
  Encrypted,
  ReplicationRunStatusMessage,
  ReplicationRunId,
  KmsKeyId,
  Description
}
import scala.jdk.CollectionConverters._
final case class ReplicationRun(
    replicationRunId: Optional[ReplicationRunId] = Optional.Absent,
    state: Optional[zio.aws.sms.model.ReplicationRunState] = Optional.Absent,
    `type`: Optional[zio.aws.sms.model.ReplicationRunType] = Optional.Absent,
    stageDetails: Optional[zio.aws.sms.model.ReplicationRunStageDetails] =
      Optional.Absent,
    statusMessage: Optional[ReplicationRunStatusMessage] = Optional.Absent,
    amiId: Optional[AmiId] = Optional.Absent,
    scheduledStartTime: Optional[Timestamp] = Optional.Absent,
    completedTime: Optional[Timestamp] = Optional.Absent,
    description: Optional[Description] = Optional.Absent,
    encrypted: Optional[Encrypted] = Optional.Absent,
    kmsKeyId: Optional[KmsKeyId] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ReplicationRun = {
    import ReplicationRun.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ReplicationRun
      .builder()
      .optionallyWith(
        replicationRunId.map(value =>
          ReplicationRunId.unwrap(value): java.lang.String
        )
      )(_.replicationRunId)
      .optionallyWith(state.map(value => value.unwrap))(_.state)
      .optionallyWith(`type`.map(value => value.unwrap))(_.`type`)
      .optionallyWith(stageDetails.map(value => value.buildAwsValue()))(
        _.stageDetails
      )
      .optionallyWith(
        statusMessage.map(value =>
          ReplicationRunStatusMessage.unwrap(value): java.lang.String
        )
      )(_.statusMessage)
      .optionallyWith(
        amiId.map(value => AmiId.unwrap(value): java.lang.String)
      )(_.amiId)
      .optionallyWith(
        scheduledStartTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.scheduledStartTime)
      .optionallyWith(
        completedTime.map(value => Timestamp.unwrap(value): Instant)
      )(_.completedTime)
      .optionallyWith(
        description.map(value => Description.unwrap(value): java.lang.String)
      )(_.description)
      .optionallyWith(
        encrypted.map(value => Encrypted.unwrap(value): java.lang.Boolean)
      )(_.encrypted)
      .optionallyWith(
        kmsKeyId.map(value => KmsKeyId.unwrap(value): java.lang.String)
      )(_.kmsKeyId)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ReplicationRun.ReadOnly =
    zio.aws.sms.model.ReplicationRun.wrap(buildAwsValue())
}
object ReplicationRun {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ReplicationRun
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ReplicationRun =
      zio.aws.sms.model.ReplicationRun(
        replicationRunId.map(value => value),
        state.map(value => value),
        `type`.map(value => value),
        stageDetails.map(value => value.asEditable),
        statusMessage.map(value => value),
        amiId.map(value => value),
        scheduledStartTime.map(value => value),
        completedTime.map(value => value),
        description.map(value => value),
        encrypted.map(value => value),
        kmsKeyId.map(value => value)
      )
    def replicationRunId: Optional[ReplicationRunId]
    def state: Optional[zio.aws.sms.model.ReplicationRunState]
    def `type`: Optional[zio.aws.sms.model.ReplicationRunType]
    def stageDetails
        : Optional[zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly]
    def statusMessage: Optional[ReplicationRunStatusMessage]
    def amiId: Optional[AmiId]
    def scheduledStartTime: Optional[Timestamp]
    def completedTime: Optional[Timestamp]
    def description: Optional[Description]
    def encrypted: Optional[Encrypted]
    def kmsKeyId: Optional[KmsKeyId]
    def getReplicationRunId: ZIO[Any, AwsError, ReplicationRunId] =
      AwsError.unwrapOptionField("replicationRunId", replicationRunId)
    def getState: ZIO[Any, AwsError, zio.aws.sms.model.ReplicationRunState] =
      AwsError.unwrapOptionField("state", state)
    def getType: ZIO[Any, AwsError, zio.aws.sms.model.ReplicationRunType] =
      AwsError.unwrapOptionField("type", `type`)
    def getStageDetails: ZIO[
      Any,
      AwsError,
      zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly
    ] = AwsError.unwrapOptionField("stageDetails", stageDetails)
    def getStatusMessage: ZIO[Any, AwsError, ReplicationRunStatusMessage] =
      AwsError.unwrapOptionField("statusMessage", statusMessage)
    def getAmiId: ZIO[Any, AwsError, AmiId] =
      AwsError.unwrapOptionField("amiId", amiId)
    def getScheduledStartTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("scheduledStartTime", scheduledStartTime)
    def getCompletedTime: ZIO[Any, AwsError, Timestamp] =
      AwsError.unwrapOptionField("completedTime", completedTime)
    def getDescription: ZIO[Any, AwsError, Description] =
      AwsError.unwrapOptionField("description", description)
    def getEncrypted: ZIO[Any, AwsError, Encrypted] =
      AwsError.unwrapOptionField("encrypted", encrypted)
    def getKmsKeyId: ZIO[Any, AwsError, KmsKeyId] =
      AwsError.unwrapOptionField("kmsKeyId", kmsKeyId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ReplicationRun
  ) extends zio.aws.sms.model.ReplicationRun.ReadOnly {
    override val replicationRunId: Optional[ReplicationRunId] =
      zio.aws.core.internal
        .optionalFromNullable(impl.replicationRunId())
        .map(value => zio.aws.sms.model.primitives.ReplicationRunId(value))
    override val state: Optional[zio.aws.sms.model.ReplicationRunState] =
      zio.aws.core.internal
        .optionalFromNullable(impl.state())
        .map(value => zio.aws.sms.model.ReplicationRunState.wrap(value))
    override val `type`: Optional[zio.aws.sms.model.ReplicationRunType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.`type`())
        .map(value => zio.aws.sms.model.ReplicationRunType.wrap(value))
    override val stageDetails
        : Optional[zio.aws.sms.model.ReplicationRunStageDetails.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.stageDetails())
        .map(value => zio.aws.sms.model.ReplicationRunStageDetails.wrap(value))
    override val statusMessage: Optional[ReplicationRunStatusMessage] =
      zio.aws.core.internal
        .optionalFromNullable(impl.statusMessage())
        .map(value =>
          zio.aws.sms.model.primitives.ReplicationRunStatusMessage(value)
        )
    override val amiId: Optional[AmiId] = zio.aws.core.internal
      .optionalFromNullable(impl.amiId())
      .map(value => zio.aws.sms.model.primitives.AmiId(value))
    override val scheduledStartTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.scheduledStartTime())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val completedTime: Optional[Timestamp] = zio.aws.core.internal
      .optionalFromNullable(impl.completedTime())
      .map(value => zio.aws.sms.model.primitives.Timestamp(value))
    override val description: Optional[Description] = zio.aws.core.internal
      .optionalFromNullable(impl.description())
      .map(value => zio.aws.sms.model.primitives.Description(value))
    override val encrypted: Optional[Encrypted] = zio.aws.core.internal
      .optionalFromNullable(impl.encrypted())
      .map(value => zio.aws.sms.model.primitives.Encrypted(value))
    override val kmsKeyId: Optional[KmsKeyId] = zio.aws.core.internal
      .optionalFromNullable(impl.kmsKeyId())
      .map(value => zio.aws.sms.model.primitives.KmsKeyId(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ReplicationRun
  ): zio.aws.sms.model.ReplicationRun.ReadOnly = new Wrapper(impl)
}
