package zio.aws.sms.model
import zio.aws.sms.model.primitives.{S3KeyName, S3BucketName}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class S3Location(
    bucket: Optional[S3BucketName] = Optional.Absent,
    key: Optional[S3KeyName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.S3Location = {
    import S3Location.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.S3Location
      .builder()
      .optionallyWith(
        bucket.map(value => S3BucketName.unwrap(value): java.lang.String)
      )(_.bucket)
      .optionallyWith(
        key.map(value => S3KeyName.unwrap(value): java.lang.String)
      )(_.key)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.S3Location.ReadOnly =
    zio.aws.sms.model.S3Location.wrap(buildAwsValue())
}
object S3Location {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.S3Location] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.S3Location = zio.aws.sms.model
      .S3Location(bucket.map(value => value), key.map(value => value))
    def bucket: Optional[S3BucketName]
    def key: Optional[S3KeyName]
    def getBucket: ZIO[Any, AwsError, S3BucketName] =
      AwsError.unwrapOptionField("bucket", bucket)
    def getKey: ZIO[Any, AwsError, S3KeyName] =
      AwsError.unwrapOptionField("key", key)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.S3Location
  ) extends zio.aws.sms.model.S3Location.ReadOnly {
    override val bucket: Optional[S3BucketName] = zio.aws.core.internal
      .optionalFromNullable(impl.bucket())
      .map(value => zio.aws.sms.model.primitives.S3BucketName(value))
    override val key: Optional[S3KeyName] = zio.aws.core.internal
      .optionalFromNullable(impl.key())
      .map(value => zio.aws.sms.model.primitives.S3KeyName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.S3Location
  ): zio.aws.sms.model.S3Location.ReadOnly = new Wrapper(impl)
}
