package zio.aws.sms.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class SSMOutput(
    s3Location: Optional[zio.aws.sms.model.S3Location] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.sms.model.SSMOutput = {
    import SSMOutput.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.SSMOutput
      .builder()
      .optionallyWith(s3Location.map(value => value.buildAwsValue()))(
        _.s3Location
      )
      .build()
  }
  def asReadOnly: zio.aws.sms.model.SSMOutput.ReadOnly =
    zio.aws.sms.model.SSMOutput.wrap(buildAwsValue())
}
object SSMOutput {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.sms.model.SSMOutput] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.SSMOutput =
      zio.aws.sms.model.SSMOutput(s3Location.map(value => value.asEditable))
    def s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly]
    def getS3Location
        : ZIO[Any, AwsError, zio.aws.sms.model.S3Location.ReadOnly] =
      AwsError.unwrapOptionField("s3Location", s3Location)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.SSMOutput
  ) extends zio.aws.sms.model.SSMOutput.ReadOnly {
    override val s3Location: Optional[zio.aws.sms.model.S3Location.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.s3Location())
        .map(value => zio.aws.sms.model.S3Location.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.SSMOutput
  ): zio.aws.sms.model.SSMOutput.ReadOnly = new Wrapper(impl)
}
