package zio.aws.sms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{
  BucketName,
  ExecutionTimeoutSeconds,
  Command,
  InstanceId
}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class SSMValidationParameters(
    source: Optional[zio.aws.sms.model.Source] = Optional.Absent,
    instanceId: Optional[InstanceId] = Optional.Absent,
    scriptType: Optional[zio.aws.sms.model.ScriptType] = Optional.Absent,
    command: Optional[Command] = Optional.Absent,
    executionTimeoutSeconds: Optional[ExecutionTimeoutSeconds] =
      Optional.Absent,
    outputS3BucketName: Optional[BucketName] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.SSMValidationParameters = {
    import SSMValidationParameters.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.SSMValidationParameters
      .builder()
      .optionallyWith(source.map(value => value.buildAwsValue()))(_.source)
      .optionallyWith(
        instanceId.map(value => InstanceId.unwrap(value): java.lang.String)
      )(_.instanceId)
      .optionallyWith(scriptType.map(value => value.unwrap))(_.scriptType)
      .optionallyWith(
        command.map(value => Command.unwrap(value): java.lang.String)
      )(_.command)
      .optionallyWith(
        executionTimeoutSeconds.map(value =>
          ExecutionTimeoutSeconds.unwrap(value): Integer
        )
      )(_.executionTimeoutSeconds)
      .optionallyWith(
        outputS3BucketName.map(value =>
          BucketName.unwrap(value): java.lang.String
        )
      )(_.outputS3BucketName)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.SSMValidationParameters.ReadOnly =
    zio.aws.sms.model.SSMValidationParameters.wrap(buildAwsValue())
}
object SSMValidationParameters {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.SSMValidationParameters
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.SSMValidationParameters =
      zio.aws.sms.model.SSMValidationParameters(
        source.map(value => value.asEditable),
        instanceId.map(value => value),
        scriptType.map(value => value),
        command.map(value => value),
        executionTimeoutSeconds.map(value => value),
        outputS3BucketName.map(value => value)
      )
    def source: Optional[zio.aws.sms.model.Source.ReadOnly]
    def instanceId: Optional[InstanceId]
    def scriptType: Optional[zio.aws.sms.model.ScriptType]
    def command: Optional[Command]
    def executionTimeoutSeconds: Optional[ExecutionTimeoutSeconds]
    def outputS3BucketName: Optional[BucketName]
    def getSource: ZIO[Any, AwsError, zio.aws.sms.model.Source.ReadOnly] =
      AwsError.unwrapOptionField("source", source)
    def getInstanceId: ZIO[Any, AwsError, InstanceId] =
      AwsError.unwrapOptionField("instanceId", instanceId)
    def getScriptType: ZIO[Any, AwsError, zio.aws.sms.model.ScriptType] =
      AwsError.unwrapOptionField("scriptType", scriptType)
    def getCommand: ZIO[Any, AwsError, Command] =
      AwsError.unwrapOptionField("command", command)
    def getExecutionTimeoutSeconds
        : ZIO[Any, AwsError, ExecutionTimeoutSeconds] = AwsError
      .unwrapOptionField("executionTimeoutSeconds", executionTimeoutSeconds)
    def getOutputS3BucketName: ZIO[Any, AwsError, BucketName] =
      AwsError.unwrapOptionField("outputS3BucketName", outputS3BucketName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.SSMValidationParameters
  ) extends zio.aws.sms.model.SSMValidationParameters.ReadOnly {
    override val source: Optional[zio.aws.sms.model.Source.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.source())
        .map(value => zio.aws.sms.model.Source.wrap(value))
    override val instanceId: Optional[InstanceId] = zio.aws.core.internal
      .optionalFromNullable(impl.instanceId())
      .map(value => zio.aws.sms.model.primitives.InstanceId(value))
    override val scriptType: Optional[zio.aws.sms.model.ScriptType] =
      zio.aws.core.internal
        .optionalFromNullable(impl.scriptType())
        .map(value => zio.aws.sms.model.ScriptType.wrap(value))
    override val command: Optional[Command] = zio.aws.core.internal
      .optionalFromNullable(impl.command())
      .map(value => zio.aws.sms.model.primitives.Command(value))
    override val executionTimeoutSeconds: Optional[ExecutionTimeoutSeconds] =
      zio.aws.core.internal
        .optionalFromNullable(impl.executionTimeoutSeconds())
        .map(value =>
          zio.aws.sms.model.primitives.ExecutionTimeoutSeconds(value)
        )
    override val outputS3BucketName: Optional[BucketName] =
      zio.aws.core.internal
        .optionalFromNullable(impl.outputS3BucketName())
        .map(value => zio.aws.sms.model.primitives.BucketName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.SSMValidationParameters
  ): zio.aws.sms.model.SSMValidationParameters.ReadOnly = new Wrapper(impl)
}
