package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ScriptType {
  def unwrap: software.amazon.awssdk.services.sms.model.ScriptType
}
object ScriptType {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ScriptType
  ): zio.aws.sms.model.ScriptType = value match {
    case software.amazon.awssdk.services.sms.model.ScriptType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ScriptType.SHELL_SCRIPT =>
      val r = SHELL_SCRIPT
      r
    case software.amazon.awssdk.services.sms.model.ScriptType.POWERSHELL_SCRIPT =>
      val r = POWERSHELL_SCRIPT
      r
  }
  case object unknownToSdkVersion extends zio.aws.sms.model.ScriptType {
    override def unwrap: software.amazon.awssdk.services.sms.model.ScriptType =
      software.amazon.awssdk.services.sms.model.ScriptType.UNKNOWN_TO_SDK_VERSION
  }
  case object SHELL_SCRIPT extends zio.aws.sms.model.ScriptType {
    override def unwrap: software.amazon.awssdk.services.sms.model.ScriptType =
      software.amazon.awssdk.services.sms.model.ScriptType.SHELL_SCRIPT
  }
  case object POWERSHELL_SCRIPT extends zio.aws.sms.model.ScriptType {
    override def unwrap: software.amazon.awssdk.services.sms.model.ScriptType =
      software.amazon.awssdk.services.sms.model.ScriptType.POWERSHELL_SCRIPT
  }
}
