package zio.aws.sms.model
import scala.jdk.CollectionConverters._
sealed trait ServerCatalogStatus {
  def unwrap: software.amazon.awssdk.services.sms.model.ServerCatalogStatus
}
object ServerCatalogStatus {
  def wrap(
      value: software.amazon.awssdk.services.sms.model.ServerCatalogStatus
  ): zio.aws.sms.model.ServerCatalogStatus = value match {
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.NOT_IMPORTED =>
      val r = NOT_IMPORTED
      r
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.IMPORTING =>
      val r = IMPORTING
      r
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.AVAILABLE =>
      val r = AVAILABLE
      r
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.DELETED =>
      val r = DELETED
      r
    case software.amazon.awssdk.services.sms.model.ServerCatalogStatus.EXPIRED =>
      val r = EXPIRED
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.UNKNOWN_TO_SDK_VERSION
  }
  case object NOT_IMPORTED extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.NOT_IMPORTED
  }
  case object IMPORTING extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.IMPORTING
  }
  case object AVAILABLE extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.AVAILABLE
  }
  case object DELETED extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.DELETED
  }
  case object EXPIRED extends zio.aws.sms.model.ServerCatalogStatus {
    override def unwrap
        : software.amazon.awssdk.services.sms.model.ServerCatalogStatus =
      software.amazon.awssdk.services.sms.model.ServerCatalogStatus.EXPIRED
  }
}
