package zio.aws.sms.model
import zio.prelude.data.Optional
import zio.aws.core.{AwsError, BuilderHelper}
import zio.ZIO
import zio.aws.sms.model.primitives.{LaunchOrder, ServerGroupId}
import java.lang.Integer
import scala.jdk.CollectionConverters._
final case class ServerGroupLaunchConfiguration(
    serverGroupId: Optional[ServerGroupId] = Optional.Absent,
    launchOrder: Optional[LaunchOrder] = Optional.Absent,
    serverLaunchConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerLaunchConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration = {
    import ServerGroupLaunchConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration
      .builder()
      .optionallyWith(
        serverGroupId.map(value =>
          ServerGroupId.unwrap(value): java.lang.String
        )
      )(_.serverGroupId)
      .optionallyWith(
        launchOrder.map(value => LaunchOrder.unwrap(value): Integer)
      )(_.launchOrder)
      .optionallyWith(
        serverLaunchConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverLaunchConfigurations)
      .build()
  }
  def asReadOnly: zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly =
    zio.aws.sms.model.ServerGroupLaunchConfiguration.wrap(buildAwsValue())
}
object ServerGroupLaunchConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerGroupLaunchConfiguration =
      zio.aws.sms.model.ServerGroupLaunchConfiguration(
        serverGroupId.map(value => value),
        launchOrder.map(value => value),
        serverLaunchConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverGroupId: Optional[ServerGroupId]
    def launchOrder: Optional[LaunchOrder]
    def serverLaunchConfigurations
        : Optional[List[zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly]]
    def getServerGroupId: ZIO[Any, AwsError, ServerGroupId] =
      AwsError.unwrapOptionField("serverGroupId", serverGroupId)
    def getLaunchOrder: ZIO[Any, AwsError, LaunchOrder] =
      AwsError.unwrapOptionField("launchOrder", launchOrder)
    def getServerLaunchConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverLaunchConfigurations",
      serverLaunchConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration
  ) extends zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly {
    override val serverGroupId: Optional[ServerGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupId())
      .map(value => zio.aws.sms.model.primitives.ServerGroupId(value))
    override val launchOrder: Optional[LaunchOrder] = zio.aws.core.internal
      .optionalFromNullable(impl.launchOrder())
      .map(value => zio.aws.sms.model.primitives.LaunchOrder(value))
    override val serverLaunchConfigurations
        : Optional[List[zio.aws.sms.model.ServerLaunchConfiguration.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.serverLaunchConfigurations())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.sms.model.ServerLaunchConfiguration.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupLaunchConfiguration
  ): zio.aws.sms.model.ServerGroupLaunchConfiguration.ReadOnly = new Wrapper(
    impl
  )
}
