package zio.aws.sms.model
import zio.aws.sms.model.primitives.ServerGroupId
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters._
final case class ServerGroupValidationConfiguration(
    serverGroupId: Optional[ServerGroupId] = Optional.Absent,
    serverValidationConfigurations: Optional[
      Iterable[zio.aws.sms.model.ServerValidationConfiguration]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration = {
    import ServerGroupValidationConfiguration.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration
      .builder()
      .optionallyWith(
        serverGroupId.map(value =>
          ServerGroupId.unwrap(value): java.lang.String
        )
      )(_.serverGroupId)
      .optionallyWith(
        serverValidationConfigurations.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.serverValidationConfigurations)
      .build()
  }
  def asReadOnly
      : zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly =
    zio.aws.sms.model.ServerGroupValidationConfiguration.wrap(buildAwsValue())
}
object ServerGroupValidationConfiguration {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.sms.model.ServerGroupValidationConfiguration =
      zio.aws.sms.model.ServerGroupValidationConfiguration(
        serverGroupId.map(value => value),
        serverValidationConfigurations.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def serverGroupId: Optional[ServerGroupId]
    def serverValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerValidationConfiguration.ReadOnly]
    ]
    def getServerGroupId: ZIO[Any, AwsError, ServerGroupId] =
      AwsError.unwrapOptionField("serverGroupId", serverGroupId)
    def getServerValidationConfigurations: ZIO[Any, AwsError, List[
      zio.aws.sms.model.ServerValidationConfiguration.ReadOnly
    ]] = AwsError.unwrapOptionField(
      "serverValidationConfigurations",
      serverValidationConfigurations
    )
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration
  ) extends zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly {
    override val serverGroupId: Optional[ServerGroupId] = zio.aws.core.internal
      .optionalFromNullable(impl.serverGroupId())
      .map(value => zio.aws.sms.model.primitives.ServerGroupId(value))
    override val serverValidationConfigurations: Optional[
      List[zio.aws.sms.model.ServerValidationConfiguration.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.serverValidationConfigurations())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.sms.model.ServerValidationConfiguration.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.sms.model.ServerGroupValidationConfiguration
  ): zio.aws.sms.model.ServerGroupValidationConfiguration.ReadOnly =
    new Wrapper(impl)
}
